function MGtentnotran2(alpha,beta,gamma, tau, x0, T, n , w, l, p)
%The critical points M_n are the minima of the x(t) coordinate lower than the
%bound l. 
%T is the time interval on which the solution is integrated
%n is the number of equal steps in the interval [0,tau]
% w is an arbitrary delay to compute a projection 
%Only points with x(t-w) coordinate less than l are considered
%First the solution is integrate with the function MGsolver 

ddefun = @(t, x, x_delayed) MGequation(t, x, x_delayed, alpha,beta,gamma);
delay = tau;
h=tau/n;          %step size 
T=floor(T/h)*h;   %update of the time T, according to the stepsize h
N=p*T/h;          %number of steps in the interval [T-p*T,T]
tspan = linspace(T-p*T,T,N);
sol = dde23(ddefun, delay, x0, tspan);
tspanx= linspace(T-p*T,T-w, N);  
solx = deval(sol,tspanx);   %solx is x(t-w)
tspany= linspace(T-p*T+w,T, N);
soly = deval(sol,tspany);   %soly is x(t)
L=length(solx);
X=soly(2:L-1);
Y=soly(1:L-2);
Z=soly(3:L);

indcrit=find( X<Y & X<Z & X<l);    %indeces of the critical points 
crit= X(indcrit);                  %critical points
Mn_1= [];
Mn=[];
Mn_1= crit(1:end-1);
Mn=crit(2:end);

plot(Mn_1, Mn, 'r.');
titolo = ['$\alpha = ' num2str(alpha) ', \ \beta = ' num2str(beta) ', \ \gamma = ' num2str(gamma) ', \ \tau = ' num2str(tau) ', \ w = ' num2str(w) ', \ l = ' num2str(l) ', \ T = ' num2str(T) ', \ p = ' num2str(p) '$'];
title(titolo, 'Interpreter','latex')
axis equal;
xlabel('M_{n-1}');
ylabel('M_n');
grid on;

end
