function MGsolvernotran(alpha,beta,gamma, tau, x0, T, n, p)
%Plots the trajectory of the solution of the Mackey-Glass equation corresponding to the given
%parameters alpha,beta,gamma, tau and the constant initial condition (function) x0
%T is the imput time
%n is the number of equal steps in [0, tau]
%p is the last percentage of the solution considered in order to avoid transient behavior
%if p=0.1 then only the last 10% of the solution is considered for the plot
h=tau/n;          %step size in the interval [0, tau]
T=floor(T/h)*h;   %update of the time T, according to the stepsize h
N=p*T/h;          %number of steps in the interval [T-p*T,T]
ddefun = @(t, x, x_delayed) MGequation(t, x, x_delayed, alpha,beta,gamma);
delay = tau;
tspan = linspace(0,T,T/h);
y = dde23(ddefun, delay, x0, tspan);

tspan=linspace(T-p*T,T,N);
sol = deval(y,tspan);
plot(tspan, sol);     % Plot of the trajectory of the solution
xlabel('t');
ylabel('x(t)');
title('Trajectory of the solution');
end