function sol = MGsolver(alpha,beta,gamma, tau, x0, T, n)
%Plots the trajectory of the solution of the Mackey-Glass equation corresponding to the given
%parameters alpha,beta,gamma, tau and the constant initial condition (function) x0
%T is the length of the time interval
%n is the number of equal steps in the interval [0,tau]
%Returns the solution sol
ddefun = @(t, x, x_delayed) MGequation(t, x, x_delayed, alpha,beta,gamma);
delay = tau;
h=tau/n;          %step length in the interval [0, tau]
T=floor(T/h)*h;   %update of the time T, according to the stepsize h
N=T/h;            %number of points considered in [0,T]
tspan = linspace(0,T,N);
y = dde23(ddefun, delay, x0, tspan);
% Plot of the trajectory of the solution
sol = deval(y,tspan);
plot(tspan, sol);
xlabel('t');
ylabel('x(t)');
title('Trajectory of the solution');
end