function dxdt = MGequation (t,x, x_delayed, alpha,beta,gamma)
% MGequation (alpha,beta,gamma,tau) is the vectorial field of the Mackey-Glass equation
% INPUT :
% t        (1x1)        - current time 
% x        (1x1)        - current state (x(t))
% x_delayed(1x1)        - delayed state (x(t - tau))
% alpha, beta, gamma, tau  (1x1)        - parameters
% OUTPUT :
% vectorial field of the Mackey-Glass equation
dxdt =   beta * (x_delayed / (1 + (x_delayed)^alpha)) - gamma * x ;
end

