function MGattractor3D(alpha,beta,gamma, tau, x0, T, n , w1 , w2)
%Plots the three-dimensional projection of the strange attractor corresponding to the given
%parameters alpha,beta,gamma, tau and the constant initial condition (function) x0
%plotting x(t) as a function of x(t-w)
%T is the input time interval
%n is the number of equal steps in the interval [0,tau]
%w1, w2 are arbitrary delays to compute a projection 
%First the solution is integrate with the function MGsolver 

ddefun = @(t, x, x_delayed) MGequation(t, x, x_delayed, alpha,beta,gamma);
delay = tau;
h=tau/n;          %step size in the interval [0, tau]
T=floor(T/h)*h;   %update of the time T, according to the step size h
N= T/h;           %number of points considered in [0, T]
tspan = linspace(0,T+w1+w2,n);
sol = dde23(ddefun, delay, x0, tspan);
tspanx= linspace(w2,T-w1, N);
solx = deval(sol,tspanx);     %solx is x(t-w1)
tspany= linspace(w1,T-w2, N);
soly = deval(sol,tspany);     %soly is x(t-w2)
tspanz= linspace(w1+w2,T, N);
solz = deval(sol,tspanz);      %solz is x(t)
titolo = ['$\alpha = ' num2str(alpha) ', \ \beta = ' num2str(beta) ', \ \gamma = ' num2str(gamma) ',   \ \tau = ' num2str(tau) ' , \ w_1 = ' num2str(w1) ',  \ w_2 = ' num2str(w2) ', \ T = ' num2str(T) '$'];
title(titolo, 'Interpreter','latex')
plot3(solx, soly, solz, 'LineWidth', 1);
view(40, 10);
axis equal;
grid on;
xlabel('x(t-w_1)');
ylabel('x(t-w_2)');
zlabel('x(t)');
end