function MGattractor2Dnotran(alpha,beta,gamma, tau, x0, T, n , w, p)
%Plots the two-dimensional projection of the strange attractor corresponding to the given
%parameters alpha,beta,gamma, tau and the constant initial condition (function) x0
%plotting x(t) as a function of x(t-w)
%T is the imput time
%n is the number of equal steps in the interval [0,tau]
% w is an arbitrary delay to compute a projection  
%p is the last percentage of the solution considered 
%if p=0.1 then only the last 10% of the solution is considered for the plot
%in order to avoid transient behavior
%First the solution is integrate with the function MGsolver
h=tau/n;          %step size in the interval [0, tau]
T=floor(T/h)*h;   %update of the time T, according to the step size h
N=p*T/h;            %number of steps in the interval [T-p*T,T]
ddefun = @(t, x, x_delayed) MGequation(t, x, x_delayed, alpha,beta,gamma);
delay = tau;
tspan = linspace(0, T+w,T/h);     %T/h is the number of steps in  [0,T]
sol = dde23(ddefun, delay, x0, tspan);
tspanx= linspace(T-p*T-w, T, N);
solx = deval(sol,tspanx);            %solx is x(t-w)
tspany= linspace(T-p*T,T+w,  N);
soly = deval(sol,tspany);
plot(solx, soly);                    %solx is x(t)
titolo = ['$\alpha = ' num2str(alpha) ', \ \beta = ' num2str(beta) ', \ \gamma = ' num2str(gamma) ',   \ \tau = ' num2str(tau) ' , \ w = ' num2str(w) ', \ p = ' num2str(p) ', \ T = ' num2str(T) '$'];
title(titolo, 'Interpreter','latex')
axis equal;
xlabel('x(t-w)');
ylabel('x(t)');

end