function MGattractor2D(alpha,beta,gamma, tau, x0, T, n , w)
%Plots the two-dimensional projection of the strange attractor corresponding to the given
%parameters alpha,beta,gamma, tau and the constant initial condition (function) x0
%plotting x(t) as a function of x(t-w)
%T is the imput time
%n is the number of equal steps in the interval [0,tau]
% w is an arbitrary delay to compute a projection 
%First the solution is integrated with the function MGsolver 

ddefun = @(t, x, x_delayed) MGequation(t, x, x_delayed, alpha,beta,gamma);
delay = tau;
h=tau/n;          %step length in the interval [0, tau]
T=floor(T/h)*h;   %update of the time T, according to the stepsize h
N=floor(T/h);     %number of points considered in [0,T]
tspan = linspace(0,T,N);
sol = dde23(ddefun, delay, x0, tspan);
tspanx= linspace(0,T-w, N);
solx = deval(sol,tspanx);
tspany= linspace(w,T, N);
soly = deval(sol,tspany);
titolo = ['$\alpha = ' num2str(alpha) ', \ \beta = ' num2str(beta) ', \ \gamma = ' num2str(gamma) ', \ \tau = ' num2str(tau) '$'];
title(titolo, 'Interpreter','latex');
plot(solx, soly);
axis equal;
xlabel('x(t-\tau)');
ylabel('x(t)');

end